#include <algorithm>
#include <limits.h>
#include <iomanip>
#include <iostream>
#include <vector>
#include <string>
#include <chrono>
using namespace std;
typedef long long ll;

bool check_palindrome(int n, pair<int,int> odd_and_negative_cnt)
{
	int odd_cnt = odd_and_negative_cnt.first;
	int negative_cnt = odd_and_negative_cnt.second;
	if (negative_cnt > 0)
	{
		return false;
	}
	if (n % 2 == 0)
	{
		return odd_cnt == 0;
	}
	else
	{
		return odd_cnt == 1;
	}
}

// Returns new odd_cnt, negative_cnt
pair<int,int> update_letter_cnt(pair<int,int> odd_and_negative_cnt, vector<int>& letter_cnt, char c, int delta)
{
	int odd_cnt = odd_and_negative_cnt.first;
	int negative_cnt = odd_and_negative_cnt.second;

	int pos = c - 'a';
	int prev_cnt = letter_cnt[pos];
	letter_cnt[pos] += delta;
	int new_cnt = letter_cnt[pos];

	if (abs(prev_cnt) % 2 == 0 && abs(new_cnt) % 2 == 1)
		odd_cnt++;
	else if(abs(prev_cnt) % 2 == 1 && abs(new_cnt) % 2 == 0)
		odd_cnt--;
	
	if (prev_cnt < 0 && new_cnt >= 0)
	{
		negative_cnt--;
	}
	else if (prev_cnt >= 0 && new_cnt < 0)
	{
		negative_cnt++;
	}
	return { odd_cnt, negative_cnt };
}

int solve_larger_than_half(const string& s)
{
	int n = s.size();
	int mid_point = (n % 2 == 0 ? n / 2 : n / 2 + 1);

	vector<int> letter_cnt(30);
	pair<int, int> odd_and_negative_cnt = { 0,0 };
	for (int i = 0; i < mid_point; i++)
		odd_and_negative_cnt = update_letter_cnt(odd_and_negative_cnt, letter_cnt, s[i], 1);
	for (int i = mid_point; i < n; i++)
		odd_and_negative_cnt = update_letter_cnt(odd_and_negative_cnt, letter_cnt, s[i], -1);
	
	int current_len = mid_point;
	if (check_palindrome(n, odd_and_negative_cnt))
		return current_len;
	for (int i = mid_point; i < n; i++)
	{
		current_len++;
		odd_and_negative_cnt = update_letter_cnt(odd_and_negative_cnt, letter_cnt, s[i], 2);
		if (check_palindrome(n, odd_and_negative_cnt))
			return current_len;
	}
	return INT_MAX;
}

int solve_smaller_than_half(const string& s)
{
	int n = s.size();
	int mid_point = n / 2;
	int l = mid_point, r = mid_point;
	if (n % 2 == 0)
		l--;
	while (l >= 0 && s[l] == s[r])
	{
		l--;
		r++;
	}
	int len = l + 1;
	vector<int> letter_diffs(30);
	while (l >= 0)
	{
		letter_diffs[s[l] - 'a']++;
		letter_diffs[s[r] - 'a']--;
		l--;
		r++;
	}
	if (all_of(letter_diffs.begin(), letter_diffs.end(), [](int cnt) {return cnt == 0;}))
		return len;
	
	return INT_MAX;
}

string remove_equal(const string& s)
{
	int l = 0, r = s.size() - 1;
	while (l < r && s[l] == s[r])
	{
		l++;
		r--;
	}
	if (r < l)
	{
		return "";
	}
	string new_str = s.substr(l, r - l + 1);
	return new_str;
}

string rand_str(int n)
{
	string s(n,' ');
	for (int i = 0; i < n; i++)
	{
		s[i] = 'a' + rand() % 26;
	}
	return s;
}
string rand_palindrome(int n)
{
	string left_half = rand_str(n / 2);
	string right_half = left_half;
	reverse(right_half.begin(), right_half.end());
	if (n % 2 == 0)
	{
		return left_half + right_half;
	}
	else
	{
		return left_half + string(1,('a' + rand() % 26)) + right_half;
	}
}
pair<string,int> shuffle_substring(string s)
{
	int n = s.size();
	int l = rand() % n;
	int r = rand() % n;
	if (l > r)
		swap(l, r);
	
	int k = rand() % n;
	for (int i = 0; i < k; i++)
	{
		int pos1 = rand() % (r - l + 1) + l;
		int pos2 = rand() % (r - l + 1) + l;
		swap(s[pos1], s[pos2]);
	}
	return { s,r - l + 1 };
}

int solve(string s)
{
	s = remove_equal(s);
	if (s.size() <= 1)
	{
		return 1;
	}
	else
	{
		int s1 = min(solve_smaller_than_half(s), solve_larger_than_half(s));
		reverse(s.begin(), s.end());
		int s2 = min(solve_smaller_than_half(s), solve_larger_than_half(s));
		return min(s1, s2);
	}
}
void test()
{
	srand(time(0));
	for (int i = 0; i < 10000000; i++)
	{
		int n = rand() % 10000 + 1;
		string pal = rand_palindrome(n);
		auto p = shuffle_substring(pal);
		int sol = solve(p.first);
		if (sol > p.second)
		{
			cout << "wa\n";

			cout << p.first << "\n";
			cout << p.second << "\n";
		}
		else
		{
			if (i % 100 == 0)
			{
				cout << fixed;
				cout << setprecision(2);

				cout << i * 100.0 / 10000000 << "\r";
			}
		}
	}
}


int main()
{
	ios::sync_with_stdio(false);
	cin.tie(0);

	//test();

	string s; cin >> s;
	cout << solve(s) << "\n";

	return 0;
}